/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.core.util.SourcePrinter;
import com.aptana.json.IPropertyContainer;
import com.aptana.json.ISchemaContext;
import com.aptana.json.IState;
import com.aptana.json.Messages;
import com.aptana.json.SchemaArray;
import com.aptana.json.SchemaBoolean;
import com.aptana.json.SchemaEventType;
import com.aptana.json.SchemaNull;
import com.aptana.json.SchemaNumber;
import com.aptana.json.SchemaObject;
import com.aptana.json.SchemaPrimitive;
import com.aptana.json.SchemaProperty;
import com.aptana.json.SchemaString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schema
implements IState,
IPropertyContainer {
    private static final IState EMPTY_TYPE = new SchemaObject(null);
    private static final Map<String, IState> BUILTIN_TYPES = new HashMap<String, IState>();
    private String _name;
    private String _version;
    private String _description;
    private Map<String, IState> _typesByName;
    private String _rootTypeName;
    private SchemaState _currentState;

    static {
        BUILTIN_TYPES.put("Boolean", new SchemaBoolean());
        BUILTIN_TYPES.put("null", new SchemaNull());
        BUILTIN_TYPES.put("Number", new SchemaNumber());
        BUILTIN_TYPES.put("String", new SchemaString());
    }

    public IState addType(String typeName) {
        IState result = this.getType(typeName);
        if (result == EMPTY_TYPE) {
            result = this.createObject();
            this.addType(typeName, result);
        }
        return result;
    }

    protected void addType(String name, IState type) {
        if (this._typesByName == null) {
            this._typesByName = new HashMap<String, IState>();
        }
        this._typesByName.put(name, type);
    }

    public SchemaArray createArray(String elementType) {
        return new SchemaArray(this, elementType);
    }

    public SchemaObject createObject() {
        return new SchemaObject(this);
    }

    public SchemaProperty createProperty() {
        return new SchemaProperty(this);
    }

    public SchemaProperty createProperty(String name, String typeName) {
        return new SchemaProperty(this, name, typeName);
    }

    public void enter() {
        this._currentState = SchemaState.READY;
    }

    public void exit() {
        this._currentState = null;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public IState getRootType() {
        return this.getType(this.getRootTypeName());
    }

    public String getRootTypeName() {
        return this._rootTypeName;
    }

    public IState getType(String typeName) {
        IState result = null;
        if (BUILTIN_TYPES.containsKey(typeName)) {
            result = BUILTIN_TYPES.get(typeName);
        } else if (this._typesByName != null) {
            result = this._typesByName.get(typeName);
        }
        if (result == null) {
            if (typeName.startsWith("Array<")) {
                String elementType = typeName.substring(6, typeName.length() - 1);
                result = this.createArray(elementType);
            } else {
                result = EMPTY_TYPE;
            }
        }
        return result;
    }

    public String getTypeName() {
        return "Schema";
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isValidTransition(SchemaEventType event, Object value) {
        boolean result = false;
        switch (event) {
            case START_PARSE: {
                result = this._currentState == SchemaState.READY;
                break;
            }
            case END_PARSE: {
                result = this._currentState == SchemaState.IN_PARSE;
                break;
            }
            default: {
                result = this._currentState == SchemaState.READY;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processEndArray(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        IState currentType = context.getCurrentType();
        if (!(currentType instanceof SchemaArray)) throw new IllegalArgumentException(String.valueOf(Messages.Schema_Expected_End_Of_Array) + currentType.getClass().getName());
        if (currentType != null) {
            currentType.transition(context, event, value);
            currentType.exit();
        }
        if (!((currentType = context.getCurrentType()) instanceof SchemaArray)) return;
        currentType.transition(context, SchemaEventType.END_ARRAY_ENTRY, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processEndObject(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        IState currentType = context.getCurrentType();
        if (!(currentType instanceof SchemaObject)) throw new IllegalArgumentException(String.valueOf(Messages.Schema_Expected_End_Of_Object) + currentType.getClass().getName());
        if (currentType != null) {
            currentType.transition(context, event, value);
            currentType.exit();
        }
        if (!((currentType = context.getCurrentType()) instanceof SchemaArray)) return;
        currentType.transition(context, SchemaEventType.END_ARRAY_ENTRY, value);
    }

    protected void processEndParse(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) {
            throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        }
        this._currentState = SchemaState.COMPLETE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processPrimitive(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        IState currentType = context.getCurrentType();
        if (currentType instanceof SchemaArray) {
            currentType.transition(context, SchemaEventType.START_ARRAY_ENTRY, value);
            currentType = context.getCurrentType();
        }
        if (!(currentType instanceof SchemaPrimitive)) throw new IllegalArgumentException(String.valueOf(Messages.Schema_Expected_Primitive) + currentType.getClass().getName());
        if (currentType != null) {
            currentType.enter();
            currentType.transition(context, event, value);
            currentType.exit();
        }
        if (!((currentType = context.getCurrentType()) instanceof SchemaArray)) return;
        currentType.transition(context, SchemaEventType.END_ARRAY_ENTRY, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processStartArray(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        IState currentType = context.getCurrentType();
        if (currentType instanceof SchemaArray && currentType.isValidTransition(SchemaEventType.START_ARRAY_ENTRY, value)) {
            currentType.transition(context, SchemaEventType.START_ARRAY_ENTRY, value);
            currentType = context.getCurrentType();
        }
        if (!(currentType instanceof SchemaArray)) throw new IllegalArgumentException(String.valueOf(Messages.Schema_Expected_Start_Of_Array) + currentType.getClass().getName());
        if (currentType == null) return;
        currentType.enter();
        currentType.transition(context, event, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processStartObject(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.IN_PARSE) throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        IState currentType = context.getCurrentType();
        if (currentType instanceof SchemaArray) {
            currentType.transition(context, SchemaEventType.START_ARRAY_ENTRY, value);
            currentType = context.getCurrentType();
        }
        if (!(currentType instanceof SchemaObject)) throw new IllegalArgumentException(String.valueOf(Messages.Schema_Expected_Start_Of_Object) + currentType.getClass().getName());
        if (currentType == null) return;
        currentType.enter();
        currentType.transition(context, event, value);
    }

    protected void processStartParse(ISchemaContext context, SchemaEventType event, Object value) {
        if (this._currentState != SchemaState.READY) {
            throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
        }
        this._currentState = SchemaState.IN_PARSE;
        context.pushType(this.getRootTypeName(), this.getRootType());
        context.createType(this.getRootTypeName(), this.getRootType(), value);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setProperty(String propertyName, String propertyTypeName, Object value) {
        if ("name".equals(propertyName)) {
            this.setName((String)value);
        } else if ("version".equals(propertyName)) {
            this.setVersion((String)value);
        } else if ("description".equals(propertyName)) {
            this.setDescription((String)value);
        } else if ("result".equals(propertyName)) {
            this.setResult((String)value);
        } else if ("types".equals(propertyName)) {
            List types = (List)value;
            for (Object typeObject : types) {
                SchemaObject object;
                SchemaProperty nameProperty;
                if (!(typeObject instanceof SchemaObject) || (nameProperty = (object = (SchemaObject)typeObject).getProperty("name")) == null) continue;
                String name = nameProperty.getValue().toString();
                this.addType(name, object);
            }
        }
    }

    public void setResult(String typeName) {
        this._rootTypeName = typeName;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String toSource() {
        SourcePrinter writer = new SourcePrinter();
        this.toSource(writer);
        return writer.toString();
    }

    public void toSource(SourcePrinter writer) {
        writer.printWithIndent("schema ").print('\"').print(this.getName()).println('\"').increaseIndent();
        writer.printWithIndent("version := ").println(this._version);
        writer.printWithIndent("result  := ").println(this._rootTypeName);
        ArrayList<String> typeNames = new ArrayList<String>(this._typesByName.keySet());
        Collections.sort(typeNames);
        for (String typeName : typeNames) {
            writer.printWithIndent("type ").println(typeName).increaseIndent();
            SchemaObject type = (SchemaObject)this._typesByName.get(typeName);
            type.toSource(writer);
            writer.decreaseIndent();
            writer.printlnWithIndent("end type");
        }
        writer.decreaseIndent();
        writer.printlnWithIndent("end schema");
    }

    public void transition(ISchemaContext context, SchemaEventType event, Object value) {
        switch (event) {
            case START_PARSE: {
                this.processStartParse(context, event, value);
                break;
            }
            case START_OBJECT: {
                this.processStartObject(context, event, value);
                break;
            }
            case START_ARRAY: {
                this.processStartArray(context, event, value);
                break;
            }
            case PRIMITIVE: {
                this.processPrimitive(context, event, value);
                break;
            }
            case END_OBJECT: {
                this.processEndObject(context, event, value);
                break;
            }
            case END_ARRAY: {
                this.processEndArray(context, event, value);
                break;
            }
            case END_PARSE: {
                this.processEndParse(context, event, value);
                break;
            }
            default: {
                if (this._currentState == SchemaState.IN_PARSE) {
                    IState currentType = context.getCurrentType();
                    if (currentType == null) break;
                    currentType.transition(context, event, value);
                    break;
                }
                throw new IllegalStateException(String.valueOf(Messages.Schema_Unsupported_Event) + event.name());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SchemaState {
        READY,
        IN_PARSE,
        COMPLETE;

    }
}

